local unitArea = 2
local sizeRatio = math.sqrt(4 / unitArea)

DiamondPointStamp = function(canvas, x, y, radius, paint)
    local size = (radius or 2) * sizeRatio
    local path = Path.point{
        x = x,
        y = y + size,
    }:addLine{
        x = x - size,
        y = y,
    }:addLine{
        x = x,
        y = y - size,
    }:addLine{
        x = x + size,
        y = y,
    }:closeSubpath()
    canvas:setPaint(paint):fill(path)
end

return DiamondPointStamp
